\version "2.24.0"
\language "deutsch"

\paper {
 %#(set-paper-size "a4")
  %markup-system-spacing = #'((basic-distance . 1))
  %system-system-spacing = #'((basic-distance . 1))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 5\mm
  bottom-margin = 2\mm
  ragged-last-bottom=##f
  %system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "O, Haupt voll Blut und Wunden"
  subtitle = "Matthäus Passion"
  %subsubtitle = "Choral"
  composer =  "Johann Sebastian Bach (1685 – 1750)"
  %meter = "Andante"
  tagline=""
}

global = {
  %#(set-global-staff-size 19)
  \key d \minor
  \time 4/4
  \partial 4
  \set Staff.midiInstrument = "clarinet"
  \autoBeamOff
}


textOne = \lyrics {
  \set stanza = "1."
  O  Haupt voll Blut und Wun -- den, voll Schmerz und vol -- ler Hohn!
  O  Haupt, zu Spott ge- bun -- den mit ei -- ner Dor -- nen -- kron'!
  O  Haupt, sonst schön ge -- zie -- ret mit höch -- ster Ehr' und Zier,
  jetzt a -- ber hoch schimp -- fi -- ret: ge -- grü -- ßet seist du mir!
}  

textTwo = \lyrics {
  \set stanza = "2."
  Du ed -- les An -- ge -- sich -- te, vor dem sonst schrickt und scheut
  das gro -- ße Welt -- ge -- rich -- te, wie bist du so be -- speit!
  Wie bist du so er -- blei -- chet, wer hat dein Au -- gen -- licht,
  dem sonst kein Licht nicht glei -- chet, so schänd -- lich zu -- ge -- richt't?
}  

textThree = \lyrics {
  \set stanza = "3."
  Nun, was du, Herr, er -- dul -- det, ist al -- les mei -- ne Last;
  ich hab' es selbst ver -- schul -- det, was du ge -- tra -- gen hast.
  Schau' her, hier steh' ich Ar -- mer, der Zorn ver -- die -- net hat.
  Gib mir, o mein Er -- bar -- mer, den An -- blick dei -- ner Gnad'.
}

textFour = \lyrics {
  \set stanza = "4."
  Er -- ken -- ne mich, mein Hüter, mein Hir -- te, nimm mich an.
  Von dir, Quell al -- ler Gü -- te, ist mir viel Gut's ge -- tan;
  dein Mund hat mich ge -- la -- bet mit Milch und süs -- ser Kost,
  dein Geist hat mich be -- ga -- bet mit man -- cher Him -- mels -- lust.
}

textFive = \lyrics {
  \set stanza = "5."
  Ich will hier bei dir ste -- hen, ver -- ach -- te mich doch nicht;
  von dir will ich nicht ge -- hen, wenn dir dein Her -- ze bricht;
  wenn dein Haupt wird er -- blas -- sen im letz -- ten To -- des -- stoß,
  als -- dann will ich dich fas -- sen in mei -- nen Arm und Schoß.
}

textSix = \lyrics {
  \set stanza = "6."
  Wenn ich ein -- mal soll schei -- den, so schei -- de nicht von mir,
  wenn ich den Tod soll lei -- den, so tritt du dann her -- für;
  wenn mir am al -- ler -- bäng -- sten wird um das Her -- ze sein,
  so reiß mich aus den Äng -- sten kraft dei -- ner Angst und Pein.  
}

sopMusic = \relative c'' {
  a4 | 
  d c b a |
  g2 a4 \fermata e' |
  f f e8([ d]) e4 |
  d2. \fermata  a4 |
  d c b a |
  g2 a4 \fermata  e' |
  f f e8([ d]) e4 |
  d2. \fermata  f4 |
  e8([ d]) c4 d e |
  f2 f4 \fermata  c |
  d c b8([ a]) b4 |
  a2. \fermata f'!4 |
  e8([ f]) g4 f e |
  d2 e4 \fermata  a, |
  b a g c |
  a2. \fermata  \bar "|."
}


altMusic = \relative c' {
  f4 | 
  f8([ g]) a4 d,8([ e]) f4 |
  f( e) f a |
  a a a a8([ g]) |
  f2.  f4 |
%%5  
  f8([ g]) a4 d,8([ e]) f4 |
  f( e) f  a |
  a a a a8([ g]) |
  f2.  a4 |
  g g8([ f]) f4 b |
%%10
  b( a8[ g]) a4  a |
  a8([ g]) a4 g8([ fis]) g4 |
  fis2.  g4 |
  g c c c |
  c( h) c  f,8([ e]) |
%%15
  d8([ e]) f4 f e |
  f2.
}

tenorMusic = \relative c' {
  d4 | 
  d8([ e]) f4 g c, |
  d( c) c e |
  e d d cis |
  a2.  d4 |
%%5
  d8([ e]) f4 g c, |
  d( c) c  e |
  e d d cis |
  a2. d8([ c]) |
  b4 c c b8([ c]) |
%%10
  d4( c8[ b]) c4 f8([ es]) |
  d4 d d d |
  d2.  d4 |
  c8([ d]) e4 f g |
  a( g) g c, |
%%15
  b c c8([ b16 a]) g8([ c]) |
  c2.
}

bassMusic = \relative c {
  d'8([ c]) | 
  b4 a g f |
  b,( c) f cis |
  d8([ e]) f([ g]) a4 a, |
  d2. d'8([ c]) |
  b4 a g f |
  b,( c) f cis |
  d8([ e]) f([ g]) a4 a,4 |
  d2. d4 |
  g a b8([ a]) g4 |
  f2 f4 f |
  b fis g g, |
  d'2. h4 |
  c c'8([ h]) a4 g |
  f( g) c, f |
  g a8([ b]) c4 c, |
  f2.
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
       \new Voice { \global \voiceOne \sopMusic }
      \addlyrics { \textOne }
      %\addlyrics { \textTwo }
      \addlyrics { \textThree }
      %\addlyrics { \textFour }
      \addlyrics { \textFive }
      \addlyrics { \textSix }
      \new Voice { \global \voiceTwo \altMusic }
    >>
    
    \new Staff <<
      %\set Staff.instrumentName = #"B"
      \clef bass
      \new Voice { \global \voiceOne \tenorMusic }
      \new Voice { \global \voiceTwo \bassMusic }
      %\addlyrics { \menWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
    \tempo 4 = 60
    \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \myScore
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
